/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.Sets;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.OperationGroup;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.util.Tuple;
import java.util.Set;

public class GroupBoundUpdater
extends Processor {
    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        Set<OperationGroup> groups = Sets.newIdentityHashSet();
        for (Operation op : ops) {
            if (!op.isGrouped()) continue;
            groups.add(op.getGroup());
        }
        for (OperationGroup group : groups) {
            group.updateBound(this, Long.MIN_VALUE);
            long maxMinBound = Long.MIN_VALUE;
            for (Operation op : group) {
                long opBound = op.getBound().getTime();
                if (opBound <= maxMinBound) continue;
                maxMinBound = opBound;
            }
            group.updateBound(this, maxMinBound);
        }
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }
}

